reapmll1 <- function(Y, B, PHI) {
  # Inicializar variables
  n <- nrow(Y)
  m <- ncol(Y)
  t <- nrow(B)
  k <- ncol(B)
  
  Mdif <- rep(0, m)
  Mdif1 <- rep(0, m)
  Mdif2 <- rep(0, m)
  Mdisc <- rep(0, m)
  Mdisc1 <- rep(0, m)
  Mdisc2 <- rep(0, m)
  MIthres <- rep(0, m)
  PROYC <- matrix(0, nrow = m, ncol = k)
  
  # Parámetros básicos del ítem
  mu <- colMeans(Y)
  alpha <- exp(mu)
  Beta <- B
  C <- cov(Y)
  Cres <- C - (B %*% PHI %*% t(B))
  varres <- diag(Cres)
  
  # Dificultades multidimensionales
  sumb <- B %*% rep(1, k)
  sumBeta <- sumb
  ialpha <- rep(1, m) / alpha
  ialpha1 <- rep(1, m) / (3 * alpha)
  ialpha2 <- (3 * rep(1, m)) / alpha
  isumb <- rep(1, m) / sumb
  PTB <- B^B
  
  for (j in 1:m) {
    tmp1 <- ialpha[j] ^ isumb[j]
    tmp11 <- ialpha1[j] ^ isumb[j]
    tmp12 <- ialpha2[j] ^ isumb[j]
    tmp2 <- sqrt(sumb[j])
    tmp3 <- prod(PTB[j, ])
    tmp4 <- tmp3 ^ (0.5 * isumb[j])
    tmp5 <- tmp1 * (tmp2 / tmp4)
    
    Mdif[j] <- ifelse(tmp5 >= 90, 90, tmp5)
    tmp51 <- tmp11 * (tmp2 / tmp4)
    Mdif1[j] <- ifelse(tmp51 >= 90, 90, tmp51)
    tmp52 <- tmp12 * (tmp2 / tmp4)
    Mdif2[j] <- ifelse(tmp52 >= 90, 90, tmp52)
  }
  
  # Proyecciones ortogonales (coordenadas)
  for (j in 1:m) {
    for (i in 1:k) {
      tmp6 <- sqrt(sumb[j])
      tmp7 <- sqrt(Beta[j, i]) / tmp6
      PROYC[j, i] <- Mdif[j] * tmp7
    }
  }
  
  # Discriminaciones multidimensionales
  for (j in 1:m) {
    Mdisc[j] <- 0.25 * (sumb[j] / Mdif[j])
    Mdisc1[j] <- 0.25 * 0.75 * (sumb[j] / Mdif1[j])
    Mdisc2[j] <- 0.25 * 0.75 * (sumb[j] / Mdif2[j])
  }
  
  return(list(alpha = alpha, Beta = Beta, sumBeta = sumBeta, varres = varres, Mdif = Mdif, Mdisc1 = Mdisc1, Mdisc = Mdisc, Mdisc2 = Mdisc2, PROYC = PROYC))
}

           