
# Function eapmulllcon in R
eapmulllcon <- function(X, bet, alpha, vare, nodos, index_nodos) {
  n <- size(X)[1]
  m <- size(X)[2]
  if (n > m) {
    ni <- n
  } else {
    ni <- m
  }
  
  k <- ncol(bet)
  nnod <- nrow(nodos)
  hnod <- nrow(index_nodos)
  sige <- sqrt(vare)
  
  L1 <- matrix(0, nnod^k, 1)
  nume_th <- rep(0, k)
  nume_se <- rep(0, k)
  
  TH <- rep(0, k)
  ST <- rep(0, k)
  RELI <- rep(0, k)
  
  deno <- 0
  p <- rep(0, ni)
  
  for (h in 1:hnod) {
    for (j in 1:ni) {
      tmp5 <- 0
      tmp1 <- (0.399 / sige[j])
      tmp2 <- 1 / (X[j] * (1 - X[j]))
      tmp3 <- log(X[j] / (1 - X[j]))
      tmp4 <- log(alpha[j])
      
      for (i in 1:k) {
        tmp5 <- tmp5 + bet[j, i] * log(nodos[index_nodos[h, i], 1])
      }
      
      tmp6 <- ((tmp3 - tmp4 - tmp5) / sige[j])^2
      tmp7 <- exp(-0.5 * tmp6)
      tmp8 <- tmp1 * tmp2 * tmp7
      p[j] <- tmp8
    }
    
    L1[h, 1] <- 1
    for (j in 1:ni) {
      L1[h, 1] <- L1[h, 1] * p[j]
    }
    
    pp <- 1
    for (i in 1:k) {
      pp <- pp * nodos[index_nodos[h, i], 2]
    }
    
    pp <- L1[h, 1] * pp
    deno <- deno + pp
    
    for (i in 1:k) {
      nume_th[i] <- nume_th[i] + pp * nodos[index_nodos[h, i], 1]
      nume_se[i] <- nume_se[i] + pp * nodos[index_nodos[h, i], 1] * nodos[index_nodos[h, i], 1]
    }
  }
  
  vartrue <- 4.67
  
  for (i in 1:k) {
    TH[i] <- nume_th[i] / deno
    vt <- (nume_se[i] / deno) - (TH[i]^2)
    if (vt <= 0) {
      ST[i] <- 0
    } else {
      ST[i] <- sqrt(vt)
    }
    
    RELI[i] <- (vartrue - (ST[i]^2)) / vartrue
    if (RELI[i] <= 0) {
      RELI[i] <- 0.01
    }
  }
  
  return(list(TH, ST, RELI))
}
