
  source("MULTIPOL.R")
  
  # REQUIRED PACKAGES
  required_packages <- c("shiny", "shinydashboard", "shinyjs", "shinyWidgets", "DT", "shinycssloaders")
  
  for(pkg in required_packages){
    if (!requireNamespace(pkg, quietly = TRUE)) {
      install.packages(pkg)
    }
    library(pkg, character.only = TRUE)
  }

  # Define UI
  ui <- fluidPage(
    titlePanel(div("MULTIPOL", style = "color: #304674" )),
    sidebarLayout(
      sidebarPanel(
        tags$style(".well {background-color:#A7C7E7;}"),

        uiOutput("fileInputUI"),

        fileInput("X", "Data 0-1 (X)"),
        
        fileInput("B", "Beta matrix (B)"),

        fileInput("PHI", "PHI"),
        
        radioButtons("selector", "Method:",
                     choices = c("Fast", "Accurate"),
                     selected = "Fast"),

        actionButton("compute_button", "Compute")


      ),
      mainPanel(

        withSpinner(verbatimTextOutput("output_results", placeholder = TRUE)),

        useShinyjs()
      )
    )
  )

  # Define server
  server <- function(input, output) {

    output$output_results <- renderText({
      "Welcome to MULTIPOL GUI version!\n
Please, configure the analysis using the side menu."
    })
    
    observeEvent(input$selector, {
      if (input$selector == "Accurate") {
        showModal(
          modalDialog(
            title = "Warning",
            "The Accurate method may take significantly more computing time. 
          Are you sure you want to proceed?",
            footer = modalButton("I agree"),
            easyClose = TRUE
          )
        )
      }
    })
    

    observeEvent(input$compute_button, {

      runjs("window.scrollTo(0, 0);")


        if (is.null(input$X) || is.null(input$PHI) || is.null(input$B)){
          showModal(modalDialog(
            title = "Warning",
            "Some requiered fields are empty. Please, select a data file for each field.",
            easyClose = TRUE
          ))
        }
        else {
          
          # Sanity checks, change all sep to \t
          buff <- readLines(input$X$datapath, warn = F)
          buff <- gsub("[;, ]", "\t",buff)
          X <- as.matrix(read.table(text = buff))
          
          # Sanity checks, change all sep to \t
          buff <- readLines(input$B$datapath, warn = F)
          buff <- gsub("[;, ]", "\t",buff)
          B <- as.matrix(read.table(text = buff))
          
          # Sanity checks, change all sep to \t
          buff <- readLines(input$PHI$datapath, warn = F)
          buff <- gsub("[;, ]", "\t",buff)
          PHI <- as.matrix(read.table(text = buff))
              
          # Waiting bar
          if (input$selector == "Fast"){
            output$output_results <- renderPrint({
            MULTIPOL(X = X, B = B, PHI = PHI, method = "fast", output = TRUE)
            })
          }
          
          if (input$selector == "Accurate"){
            output$output_results <- renderPrint({
              MULTIPOL(X = X, B = B, PHI = PHI, method = "accurate", output = TRUE)
            })
          }
        }

    })
  }


  # Crea la aplicación Shiny
  shinyApp(ui, server)


